--[[----------------------------------------------------------------------------
	Copyright 2008 João Liborio Cardoso
	All rights reserved
	
	Bongos Coords is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License version 3 as published by the Free Software Foundation.
	Bongos Coords is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License (<http://www.gnu.org/licenses/>) for more details.
---------------------------------------------------------------------------]]--

local L = LibStub('AceLocale-3.0'):GetLocale('Bongos3-Coords')
local Bongos =  LibStub('AceAddon-3.0'):GetAddon('Bongos3')
local Coords = Bongos:NewModule('Coords', 'AceEvent-3.0')


--[[ Bongos Bar ]]--

function Coords:Load()
	local defaults = {
		format = "X/Y",
		point = "TOP",
		precision = 2,
		y = -97.4,
		x = -4.5,
	}
	
	self.bar, isNew = Bongos.Bar:Create('coords', defaults, nil, 'HIGH')
	
	self.bar.sets.format = self.bar.sets.format or "X/Y" --temporary
	self.bar.sets.precision = self.bar.sets.precision or 2
	
	if isNew then
		self.LoadBar(self.bar)
	end
end

function Coords:Unload()
	self.bar:Destroy()
end

function Coords:LoadBar()

	for k,v in pairs(Coords) do self[k] = v end
	self.display = Bongos:CreateSimpleIndicator(self)
	self:UpdateCoords()
	
	self:RegisterEvent('ZONE_CHANGED', 'UpdateCoords')
	
	self:RegisterEvent('PLAYER_CONTROL_LOST', 'StartUpdate')
	self:RegisterEvent('PLAYER_CONTROL_GAINED', 'StopUpdate')
	
	self:RegisterEvent('AUTOFOLLOW_BEGIN', 'StartUpdate')
	self:RegisterEvent('AUTOFOLLOW_END', 'StopUpdate')
	
	self:HookMovement("MoveBackward")
	self:HookMovement("MoveForward")
	self:HookMovement("StrafeRight")
	self:HookMovement("StrafeLeft")
	
	hooksecurefunc("ToggleAutoRun", function()
		if not self.isRunning then
			self:StartUpdate()
		else
			self:StopUpdate()
		end
	end)
end


--[[ Frame Code ]]--

if not Bongos.CreateSimpleIndicator then
	function Bongos:CreateSimpleIndicator(parent) --common code for Bongos_Clock
	
		local text = parent:CreateFontString(nil, 'OVERLAY')
		text:SetFontObject('GameFontNormalSmall')
		text:SetAllPoints(parent)
		
		parent:SetHeight(24)
		parent:SetWidth(70)
		
		return text
	end
end


--[[ Coords Update ]]--

function Coords:HookMovement(func)
	hooksecurefunc(func..'Start', function()
		self:StartUpdate()
	end)
	hooksecurefunc(func..'Stop', function()
		self:StopUpdate()
	end)
end

function Coords:StartUpdate()
	self:SetScript('OnUpdate', self.UpdateCoords)
	self.isRunning = true
end

function Coords:StopUpdate()
	self:SetScript('OnUpdate', nil)
	self.isRunning = nil
end

function Coords:UpdateCoords()
	if not WorldMapFrame:IsShown() then
		SetMapToCurrentZone()
		local x, y = GetPlayerMapPosition('player')
		local precision = 10 ^ self.sets.precision
		local text = self.sets.format
		
		text = text:gsub('X', floor(x * precision) / precision * 100, 1)
		text = text:gsub('Y', floor(y * precision) / precision * 100, 1)	
		
		self.display:SetText(text)
		self:SetWidth(max(70, self.display:GetStringWidth()))
	end
end


--[[ Menu ]]--

function Coords:CreateMenu()
	local menu = Bongos.Menu:Create(self.id)
	local panel = menu:AddLayoutPanel()
	
	local function Slider_OnShow(slider)
		slider:SetValue(self.sets.precision)
	end
	
	local function Slider_UpdateValue(slider, value)
		self.sets.precision = value
		self:UpdateCoords()
	end
	
	local slider = panel:CreateSlider(L.Precision, 2, 4, 1, Slider_OnShow, Slider_UpdateValue)
	
	local editBox = CreateFrame('EditBox', panel:GetName() .. 'Format', panel,  'InputBoxTemplate')
	editBox:SetScript('OnTextChanged', function(f) self.sets.format = f:GetText() self:UpdateCoords() end)
	editBox:SetScript('OnShow', function(f) f:SetText(self.sets.format) end)
	editBox:SetWidth(120) editBox:SetHeight(20)
	editBox:SetJustifyH('Center')
	editBox:SetAutoFocus(false)
	
	local text = editBox:CreateFontString(nil, 'BACKGROUND')
	text:SetFontObject('GameFontNormalSmall')
	text:SetPoint('BOTTOM', editBox, 'TOP', 0, 3)
	text:SetText(L.Format)
	
	editBox:SetPoint('BOTTOM', panel.slider, 'TOP', 3, 17)
	panel.height = panel.height + 45
	
	return menu
end